<?xml version="1.0"?>
<xsl:stylesheet>
<xsl:output omit-xml-declaration="true" method="html" indent="no"/>

<!--	movieArt template. Deals with cover art.
-->
<xsl:template name="movieArt">
	<xsl:param name="height" select="''"/>
	<xsl:param name="width" select="''"/>
	<xsl:param name="altText" select="''"/>
	<xsl:param name="artRoot" select="'default'"/>
	<xsl:variable name="artFile" select="RELEASES/RELEASES_ITEM/COVERARTNAME"/>
	<xsl:choose>
	<xsl:when test="string-length($artFile)  &gt; 0">
			<xsl:variable name="movieArtPath" select="concat($movieArtRoot, '/', substring($artFile, 5, 2), '/', $artFile, '.jpg')"/>
			<img border="0" hspace="3" vspace="3">
				<xsl:attribute name="alt"><xsl:value-of select="$altText"/></xsl:attribute>
				<xsl:attribute name="src"><xsl:value-of select="$movieArtPath"/></xsl:attribute>
				<xsl:if test="string-length($height) &gt; 0">
					<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="string-length($width) &gt; 0">
					<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
				</xsl:if>
			</img>
		</xsl:when>
		<xsl:otherwise><img border="0" src="images/placeholder3.gif" height="100"/></xsl:otherwise>
	</xsl:choose>

</xsl:template>
<!-- Template for long movie names, including year and MPAA rating
-->
<xsl:template name="movieLongName">
	<xsl:param name="movieArticle" select="TITLES/TITLES_ITEM/TITLEARTICLE"/>
	<xsl:if test="string-length($movieArticle) &gt; 0"><xsl:value-of select="$movieArticle" />&#160;</xsl:if>
	<xsl:value-of select="TITLES/TITLES_ITEM/TITLE"/> (<xsl:value-of select="ORIGRELEASEYEAR"/>) <xsl:value-of select="RELEASES/RELEASES_ITEM/RATINGTEXT"/>
</xsl:template>

<!-- Template for short movie names, including year
-->
<xsl:template name="movieShortName">
	<xsl:param name="movieArticle" select="TITLES/TITLES_ITEM/TITLEARTICLE"/>
	<xsl:if test="string-length($movieArticle) &gt; 0"><xsl:value-of select="$movieArticle" />&#160;</xsl:if>
	<xsl:value-of select="TITLES/TITLES_ITEM/TITLE"/> (<xsl:value-of select="ORIGRELEASEYEAR"/>) 
</xsl:template>

<!-- 	Template to print out a list of contributors (Producers, Directors, Star, etc.)
-->
<xsl:template match="CONTRIBUTORS_ITEM" mode="contributorsList">
	<xsl:value-of select="FIRSTNAME"/><xsl:text> </xsl:text><xsl:value-of select="LASTNAME"/>
	<xsl:param name="job" select="./JOBNAME"/>
	<xsl:if test="count(following-sibling::*[JOBNAME=$job]) &gt; 0">,<xsl:text> </xsl:text></xsl:if>
</xsl:template>

<!--	Templates to list movie producer(s). Uses contributorsList template.
-->
<xsl:template match="CONTRIBUTORS" mode="movieProducer">
	<xsl:variable name="producers" select="CONTRIBUTORS_ITEM[JOBNAME='Producer']"/>
	<xsl:apply-templates select="$producers" mode="contributorsList"/>
</xsl:template>



<!--	Template to list movie director(s). Uses contributorsList template.
-->

<xsl:template match="CONTRIBUTORS" mode="movieDirector">
	<xsl:variable name="directors" select="CONTRIBUTORS_ITEM[JOBNAME='Director']"/>
	<xsl:apply-templates select="$directors" mode="contributorsList"/>
</xsl:template>

<!--	Template to list movie star(s). Uses contributorsList template.
-->
<xsl:template match="CONTRIBUTORS" mode="movieStar">
	<xsl:variable name="stars" select="CONTRIBUTORS_ITEM[JOBNAME='Star']"/>
	<xsl:apply-templates select="$stars" mode="contributorsList"/>
</xsl:template>

<!--	Template to get the movie description. Attempts to get the Synopsis note, if
		it exists. Defaults to the VideoLog template.
-->

<xsl:template match="NOTES" mode="movieDescription">
	<xsl:variable name="synopsis" select="NOTES_ITEM[NOTETYPEDESCR='Synopsis']"/>
	<xsl:choose>
		<xsl:when test="count($synopsis) &gt; 0">
			<xsl:value-of select="$synopsis/NOTETEXT"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="videologdesc" select="NOTES_ITEM[starts-with(NOTETYPEDESCR, 'VideoLog')]"/>
			<xsl:value-of select="$videologdesc/NOTETEXT"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Template to display radio buttons for interest feedback.
	Note that the font is done this messy way because NS can't handle styles in some
	places. For instnace, NS messes up styles (and <span> tags) on the MyAlkindi page, 
	but NOT on the Product Page). Curiouser and Curiouser.

-->
<xsl:template name="radioButtons">
	<xsl:param name="itemNum" select="''"/>
		<font style="font-family: Arial, Helvetica, sans-serif;font-size: 10pt;">yes
			<input type="radio" value="-2"><xsl:attribute name="onclick">selectRate(-2,<xsl:value-of select="$itemNum"/>)</xsl:attribute><xsl:attribute name="name">radio<xsl:value-of select="$itemNum"/></xsl:attribute></input>
				&#160;no<input type="radio" value="-3"><xsl:attribute name="onclick">selectRate(-3,<xsl:value-of select="$itemNum"/>)</xsl:attribute><xsl:attribute name="name">radio<xsl:value-of select="$itemNum"/></xsl:attribute></input>
				&#160;don't&#160;know<input type="radio" value="-4"><xsl:attribute name="onclick">selectRate(-4,<xsl:value-of select="$itemNum"/>)</xsl:attribute><xsl:attribute name="name">radio<xsl:value-of select="$itemNum"/></xsl:attribute></input>
		</font>
</xsl:template>

</xsl:stylesheet>
